library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity top is
    Port (
        CLK : in  std_logic;                       -- 50 MHz onboard
        LED : out std_logic_vector(7 downto 0);     -- LED[7..0]
        input : in std_logic_vector(8 downto 0);
        output : out std_logic_vector(7 downto 0);
        debugPin : out std_logic
    );
end top;

architecture Behavioral of top is
    ----------------------------------------------------------------
    -- Parameter
    ----------------------------------------------------------------
    constant CLK_HZ      : integer := 50_000_000;     -- Board-Clock
    constant CPU_HZ      : integer := 200;            -- CPU-Takt (z.B. 2 Hz)

    -- abgeleitete Konstanten
    constant DIV_HALF    : integer := CLK_HZ/(CPU_HZ*2);                 -- Halbperiode für slow_clk
    constant TICKS_PER_MS : integer := CLK_HZ / 1000;

    ----------------------------------------------------------------
    -- Signale
    ----------------------------------------------------------------
    signal slow_clk   : std_logic := '0';
    signal div_cnt    : integer range 0 to DIV_HALF-1 := 0;
    signal cpu_clk_fast : std_logic;

    signal led_bus   : std_logic_vector(7 downto 0);
    signal accu_bus  : std_logic_vector(15 downto 0);
    signal dbg_bus   : std_logic_vector(15 downto 0);
    signal inputRegister : std_logic_vector(8 downto 0) := (others => '0');
    signal outputRegister : std_logic_vector(7 downto 0) := (others => '0');

begin
    ----------------------------------------------------------------
    -- Clock Divider: 50 MHz → CPU_HZ
    ----------------------------------------------------------------
    process(CLK)
    begin
        if rising_edge(CLK) then
            if div_cnt = DIV_HALF-1 then
                div_cnt  <= 0;
                slow_clk <= not slow_clk;
            else
                div_cnt <= div_cnt + 1;
            end if;

            
        end if;
    end process;
    
    cpu_clk_fast <= CLK;
    
    cpu_0 : entity work.cpu_core0
    generic map(
        number => 0
    )
    port map (
        clk       => cpu_clk_fast,
        accu_out  => accu_bus,
        debug_cmd => dbg_bus,
        led_out   => led_bus,
        inputRegister => inputRegister,
        outputRegister => outputRegister
    );

    LED(7 downto 0) <= led_bus(7 downto 0);
    output(7 downto 0) <= outputRegister(7 downto 0);
    inputRegister(8 downto 0) <= input(8 downto 0);
    debugPin <= dbg_bus(0);
    
end Behavioral;

