library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity mem_ip is
    Port (
        clock   : in  std_logic;
        address : in  std_logic_vector(9 downto 0);
        data    : in  std_logic_vector(15 downto 0);
        wren    : in  std_logic;
        q       : out std_logic_vector(15 downto 0);
        inputRegister : std_logic_vector(8 downto 0)
    );
end mem_ip;

architecture rtl of mem_ip is
    type ram_type is array (0 to 1023) of std_logic_vector(15 downto 0);
    signal ram : ram_type;
begin
    process(clock)
    begin
        if rising_edge(clock) then
            if wren = '1' then
                ram(to_integer(unsigned(address))) <= data;
            else
                if (to_integer(unsigned(address)) = 3) then
                    q(8 downto 0) <= inputRegister;
--                elsif (to_integer(unsigned(address)) = 1021) then
--                    q <= inputRegister1;
                else
                    q <= ram(to_integer(unsigned(address)));
                end if;
            end if;
        end if;
    end process;
end rtl;
